function [Hhat,row,Full_Supports] = OracleOMP(Y,H,Phi,M,N,K,L1,L2)

Hhat=zeros(N,M,K);
Full_Supports=zeros(L1,L2,K);

for k=1:K            
    HK=H(:,:,k);
    YK=Y(:,:,k);    
    %% estimate the rows of supports
    [~,order] = sort(sum(abs(HK).^2),'descend');
    row=order(1:L1);
    row=row;
    %% estimate the columns of supports
    for r=1:L1
        h=HK(:,row(r));
        y=YK(:,row(r));
        [~,order]=sort(abs(h).^2,'descend');
        support= (order(1:L2));
        Phi_s=Phi(:,support);
        hhat=zeros(N,1);
        hhat(support,:)=inv(Phi_s'*Phi_s)*Phi_s'*y;
        Hhat(:,row(r),k)=hhat;
        Full_Supports(r,:,k)=support;
    end
end
